dnl -------------------------------------------------------------------------
dnl Try to find a file (or one of more files in a list of dirs).
dnl -------------------------------------------------------------------------

AC_DEFUN([MY_FIND_FILE],
[
    $3=""
    for i in $2;
    do
        for j in $1;
        do
	        if test -r "$i/$j"; then
		        $3=$i
                break 2
            fi
        done
    done
])

dnl -------------------------------------------------------------------------

AC_DEFUN([MY_SUBST],
dnl Substitute an instance of @$1@ with value "$2".
dnl Example: MY_SUBST(FOO,BAR) <-> @FOO@ => BAR
[
    eval "$1=$2"
    AC_SUBST($1)
])

AC_DEFUN([MY_SUBST_DEF],
dnl Substitute an instance of @$1@ with value "#define $1".
dnl Example: MY_SUBST_DEF(FOO) <-> @FOO@ => #define FOO
[
    eval "$1=\"#define $1\""
    AC_SUBST($1)
])

AC_DEFUN([MY_SUBST_UNDEF],
dnl Substitute an instance of @$1@ with value "#undef $1".
dnl Example: MY_SUBST_UNDEF(FOO) <-> @FOO@ => #undef FOO
[
    eval "$1=\"#undef $1\""
    AC_SUBST($1)
])

dnl -------------------------------------------------------------------------
dnl Check whether compiler has a working ``bool'' type.
dnl -------------------------------------------------------------------------

AC_DEFUN([MY_CHECK_BOOL],
[
    AC_MSG_CHECKING([for bool])
    AC_CACHE_VAL(my_cv_have_bool,
    [
        AC_TRY_COMPILE(
            [],
            [bool aBool = true;],
            [my_cv_have_bool=yes],
            [my_cv_have_bool=no]
        )
    ])
    AC_MSG_RESULT($my_cv_have_bool)
    if test "$my_cv_have_bool" = yes; then
        AC_DEFINE(XSID_HAVE_BOOL)
    fi 
])

dnl -------------------------------------------------------------------------
dnl Check whether C++ library has openmode ios::bin instead of ios::binary.
dnl Will define XSID_HAVE_IOS_BIN if ios::binary is not available.
dnl -------------------------------------------------------------------------

AC_DEFUN([MY_CHECK_IOS_BIN],
[
    AC_MSG_CHECKING(whether standard openmode ios::binary is available)
    AC_CACHE_VAL(my_cv_have_ios_binary,
    [
        AC_TRY_COMPILE(
            [#include <fstream.h>],
		    [ifstream myTest("test",ios::in|ios::binary);],
		    [my_cv_have_ios_binary=yes],
		    [my_cv_have_ios_binary=no]
	    )
    ])
    AC_MSG_RESULT($my_cv_have_ios_binary)
    if test "$my_cv_have_ios_binary" = no; then
        AC_DEFINE(XSID_HAVE_IOS_BIN)
    fi
])

dnl -------------------------------------------------------------------------
dnl Check whether C++ compiler supports the "nothrow allocator".
dnl Will define XSID_HAVE_NOTHROW if test code compiles.
dnl -------------------------------------------------------------------------

AC_DEFUN([MY_CHECK_NOTHROW],
[
    AC_MSG_CHECKING(whether nothrow allocator is available)
    AC_CACHE_VAL(my_cv_have_nothrow,
    [
        AC_TRY_COMPILE(
            [#include <new>],
		    [char* buf = new(std::nothrow) char[1024];],
		    [my_cv_have_nothrow=yes],
		    [my_cv_have_nothrow=no]
	    )
    ])
    AC_MSG_RESULT($my_cv_have_nothrow)
    if test "$my_cv_have_nothrow" = yes; then
        AC_DEFINE(XSID_HAVE_NOTHROW)
    fi
])

dnl -------------------------------------------------------------------------
dnl Pass C++ compiler options to libtool which supports C only.
dnl -------------------------------------------------------------------------

AC_DEFUN([MY_PROG_LIBTOOL],
[
    my_save_cc="$CC"
    my_save_cflags="$CFLAGS"
    CC="$CXX"
    CFLAGS="$CXXFLAGS"
    AM_PROG_LIBTOOL
    CC="$my_save_cc"
    CFLAGS="$my_save_cflags"
])

dnl -------------------------------------------------------------------------

AC_DEFUN([MY_TRY_LINK_SAVE],
[
    my_cxx_save="$CXX"
    my_cxxflags_save="$CXXFLAGS"
    my_ldflags_save="$LDFLAGS"
    my_libs_save="$LIBS"
])

AC_DEFUN([MY_TRY_LINK_RESTORE],
[
    CXX="$my_cxx_save"
    CXXFLAGS="$my_cxxflags_save"
    LDFLAGS="$my_ldflags_save"
    LIBS="$my_libs_save"
])

AC_DEFUN([MY_PROG_PKGCONFIG],
[
    AC_PATH_PROG(PKG_CONFIG, pkg-config, "")
])

AC_DEFUN([MY_NEED_PKGCONFIG],
[
    AC_REQUIRE([MY_PROG_PKGCONFIG])
    if test -z "$PKG_CONFIG"; then
        AC_MSG_ERROR([pkg-config not found. See http://pkgconfig.sourceforge.net])
    fi
    if ! $PKG_CONFIG --atleast-pkgconfig-version 0.5 ; then
        AC_MSG_ERROR([pkg-config too old; version 0.5 or better required.])
    fi
])

dnl -------------------------------------------------------------------------

AC_DEFUN([MY_ARGS_LIBSIDPLAY],
[
    my_sidplay_library=""
    my_sidplay_includes=""
    
    AC_ARG_WITH(libsidplay,
        [  --with-libsidplay=DIR   what the SIDPLAY install PREFIX is],
        [my_sidplay_includes="$withval/include"
         my_sidplay_library="$withval/lib"]
    )
    AC_ARG_WITH(sidplay-inc,
        [  --with-sidplay-inc=DIR  where the SIDPLAY headers are located],
        [my_sidplay_includes="$withval"],
    )
    AC_ARG_WITH(sidplay-lib,
        [  --with-sidplay-lib=DIR  where the SIDPLAY library is installed],
        [my_sidplay_library="$withval"],
    )
    AC_ARG_WITH(sidplay2,
        [  --with-sidplay2         use libsidplay 2.x (else libsidplay 1.36.x)],
        [my_with_sidplay2=yes],
        [my_with_sidplay2=no]
    )
    if test "$my_with_sidplay2" = yes; then
        AC_DEFINE(SID_WITH_SIDPLAY2)
    fi
])

dnl -------------------------------------------------------------------------
dnl Try to find SIDPLAY library and header files.
dnl $my_cv_have_sidplay will be "yes" or "no"
dnl @SIDPLAY_LDADD@ will be substituted with linker parameters
dnl @SIDPLAY_INCLUDES@ will be substituted with compiler parameters
dnl -------------------------------------------------------------------------

AC_DEFUN([MY_PATH_LIBSIDPLAY],
[
    AC_MSG_CHECKING([for working SIDPLAY library and headers])
    AC_REQUIRE([MY_ARGS_LIBSIDPLAY])
    
    # Use include path given by user (if any).
    if test -n "$my_sidplay_includes"; then
        my_sidplay_cxxflags="-I$my_sidplay_includes"
    else
        my_sidplay_cxxflags=""
    fi

    # Use library path given by user (if any).
    if test -n "$my_sidplay_library"; then
        my_sidplay_ldflags="-L$my_sidplay_library"
    else
        my_sidplay_ldflags=""
    fi

    AC_CACHE_VAL(my_cv_have_sidplay,
    [
        # Run test compilation with either standard search path
        # or user-defined paths.
        MY_TRY_LIBSIDPLAY
        if test "$my_sidplay_works" = yes; then
          my_cv_have_sidplay="my_have_sidplay=yes  \
            my_sidplay_cxxflags=\"$my_sidplay_cxxflags\"  \
            my_sidplay_ldflags=\"$my_sidplay_ldflags\"  "
        else
            MY_FIND_LIBSIDPLAY        
        fi
    ])
    eval "$my_cv_have_sidplay"
    if test "$my_have_sidplay" = yes; then
        if test -n "$my_sidplay_cxxflags" || test -n "$my_sidplay_ldflags"; then
            AC_MSG_RESULT([$my_sidplay_cxxflags $my_sidplay_ldflags])
        else
            AC_MSG_RESULT([yes])
        fi
    else
        AC_MSG_RESULT([no])
    fi
    SIDPLAY_LDADD="$my_sidplay_ldflags -lsidplay"
    SIDPLAY_INCLUDES="$my_sidplay_cxxflags"
    AC_SUBST(SIDPLAY_LDADD)
    AC_SUBST(SIDPLAY_INCLUDES)
])

dnl Functions used by MY_PATH_LIBSIDPLAY.

AC_DEFUN([MY_FIND_LIBSIDPLAY],
[
    # Search common locations where header files might be stored.
    my_sidplay_incdirs="$my_sidplay_includes /usr/include /usr/local/include \
                        /usr/lib/sidplay/include /usr/local/lib/sidplay/include"
    MY_FIND_FILE(sidplay/sidtune.h, $my_sidplay_incdirs, \
                 my_sidplay_includes)

    # Search common locations where library might be stored.
    my_sidplay_libdirs="$my_sidplay_library /usr/lib /usr/lib/sidplay \
                        /usr/local/lib/sidplay"
    MY_FIND_FILE(libsidplay.a libsidplay.so libsidplay.so.1 libsidplay.so.1.36 libsidplay.so.1.37,
                 $my_sidplaylibdirs, my_sidplay_library)

    if test -z "$my_sidplay_includes" || test -z "$my_sidplay_library"; then
        my_cv_have_sidplay="my_have_sidplay=no  \
          my_sidplay_ldflags=\"\" my_sidplay_cxxflags=\"\"  "
    else
        # Test compilation with found paths.
        my_sidplay_ldflags="-L$my_sidplay_library"
        my_sidplay_cxxflags="-I$my_sidplay_includes"
        MY_TRY_LIBSIDPLAY
        my_cv_have_sidplay="my_have_sidplay=$my_sidplay_works  \
          my_sidplay_ldflags=\"$my_sidplay_ldflags\"  \
          my_sidplay_cxxflags=\"$my_sidplay_cxxflags\"  "
    fi
])

AC_DEFUN([MY_TRY_LIBSIDPLAY],
[
    MY_TRY_LINK_SAVE

    CXXFLAGS="$CXXFLAGS $my_sidplay_cxxflags"
    LDFLAGS="$LDFLAGS $my_sidplay_ldflags"
    LIBS="$LIBS -lsidplay"

    AC_TRY_LINK(
        [#include <sidplay/sidtune.h>],
        [sidTune* myTest = new sidTune(0);],
        [my_sidplay_works=yes],
        [my_sidplay_works=no]
    )
    MY_TRY_LINK_RESTORE
])

dnl -------------------------------------------------------------------------
dnl Try to find SIDPLAY2 library and header files.
dnl $my_cv_have_sidplay2 will be "yes" or "no"
dnl @SIDPLAY_LDADD@ will be substituted with linker parameters
dnl @SIDPLAY_INCLUDES@ will be substituted with compiler parameters
dnl -------------------------------------------------------------------------

AC_DEFUN([MY_PATH_LIBSIDPLAY2],
[
    AC_MSG_CHECKING([for working SIDPLAY2 library and headers])
    
    AC_REQUIRE([MY_PROG_PKGCONFIG])
    if test -n "$PKG_CONFIG" && $PKG_CONFIG --atleast-version $LIBSIDPLAY2_REQUIRED_VERSION libsidplay2; then
        my_pkgcfg_knows=yes
    else
        my_pkgcfg_knows=no
    fi
dnl    echo "(" pkg-config knows = $my_pkgcfg_knows ")"

    AC_REQUIRE([MY_ARGS_LIBSIDPLAY])
    # Share --with-* args with libsidplay1.
    my_sidplay2_library="$my_sidplay_library"
    my_sidplay2_includes="$my_sidplay_includes"

    # Derive sidbuilders path from libsidplay2 root.
    if test -n "$my_sidplay2_library"; then
        my_sidplay2_builders="$my_sidplay2_library/sidplay/builders"
    elif test "$my_pkgcfg_knows" = yes ; then
        my_sidplay2_builders=`$PKG_CONFIG --variable=builders libsidplay2`
    fi

    AC_CACHE_VAL(my_cv_have_sidplay2,
    [
        # Run test compilation with either standard search path
        # or user-defined paths.
        my_sidplay2_ldadd="-lsidplay2"
        MY_TRY_LIBSIDPLAY2
        if test "$my_sidplay2_works" = yes; then
          my_cv_have_sidplay2="my_have_sidplay2=yes  \
            my_sidplay2_cxxflags=\"$my_sidplay2_cxxflags\"  \
            my_sidplay2_ldadd=\"$my_sidplay2_ldadd\"  \
            my_sidplay2_builders=\"$my_sidplay2_builders\"  "
        else
            MY_FIND_LIBSIDPLAY2
        fi
    ])
    eval "$my_cv_have_sidplay2"
    if test "$my_have_sidplay2" = yes; then
        if test -n "$my_sidplay2_cxxflags" || test -n "$my_sidplay2_ldadd"; then
            AC_MSG_RESULT([$my_sidplay2_cxxflags $my_sidplay2_ldadd])
        else
            AC_MSG_RESULT([yes])
        fi
    else
        AC_MSG_RESULT([no])
    fi
    SIDPLAY_LDADD="$my_sidplay2_ldadd"
    SIDPLAY_INCLUDES="$my_sidplay2_cxxflags"
    AC_SUBST(SIDPLAY_LDADD)
    AC_SUBST(SIDPLAY_INCLUDES)
])

dnl Functions used by MY_PATH_LIBSIDPLAY.

AC_DEFUN([MY_FIND_LIBSIDPLAY2],
[
    # See whether user didn't provide paths.
    if test -z "$my_sidplay2_includes"; then
        if test "$my_pkgcfg_knows" = yes ; then
            my_sidplay2_includes=`$PKG_CONFIG --variable=includedir libsidplay2`
            my_sidplay2_cxxflags=`$PKG_CONFIG --cflags libsidplay2`
        else
            # Search common locations where header files might be stored.
            my_sidplay2_incdirs="$my_sidplay2_includes $my_sidplay2_includes/include"
            MY_FIND_FILE(sidplay/sidplay2.h,$my_sidplay2_incdirs,my_sidplay2_includes)
            my_sidplay2_cxxflags="-I$my_sidplay2_includes"
        fi
    else
        my_sidplay2_cxxflags="-I$my_sidplay2_includes"
    fi
    if test -z "$my_sidplay2_library"; then
        if test "$my_pkgcfg_knows" = yes ; then
            my_sidplay2_library=`$PKG_CONFIG --variable=libdir libsidplay2`
            my_sidplay2_ldadd=`$PKG_CONFIG --libs libsidplay2`
            my_sidplay2_builders=`$PKG_CONFIG --variable=builders libsidplay2`
        else
            # Search common locations where library might be stored.
            my_sidplay2_libdirs="$my_sidplay2_library $my_sidplay2_library/lib \
                              $my_sidplay2_library/src"
            MY_FIND_FILE(libsidplay2.la,$my_sidplay2_libdirs,my_sidplay2_library)
            my_sidplay2_ldadd="-L$my_sidplay2_library -lsidplay2"
            my_sidplay2_builders="$my_sidplay2_library/sidplay/builders"
        fi
    else
        my_sidplay2_ldadd="-L$my_sidplay2_library -lsidplay2"
    fi
    if test -z "$my_sidplay2_includes" || test -z "$my_sidplay2_library"; then
        my_cv_have_sidplay2="my_have_sidplay2=no \
          my_sidplay2_ldadd=\"\" my_sidplay2_cxxflags=\"\" \
          my_sidplay2_builders=\"\" "
    else
        # Test compilation with found paths.
        my_sidplay2_ldadd="-L$my_sidplay2_library -lsidplay2"
        my_sidplay2_cxxflags="-I$my_sidplay2_includes"
        MY_TRY_LIBSIDPLAY2
        my_cv_have_sidplay2="my_have_sidplay2=$my_sidplay2_works \
          my_sidplay2_ldadd=\"$my_sidplay2_ldadd\" \
          my_sidplay2_cxxflags=\"$my_sidplay2_cxxflags\" \
          my_sidplay2_builders=\"$my_sidplay2_builders\" "
    fi
    echo "DEBUG: $my_sidplay2_cxxflags"
    echo "DEBUG: $my_sidplay2_ldadd"
])

AC_DEFUN([MY_TRY_LIBSIDPLAY2],
[
    MY_TRY_LINK_SAVE

    CXX="${SHELL-/bin/sh} ${srcdir}/libtool --mode=link $CXX"
    CXXFLAGS="$CXXFLAGS $my_sidplay2_cxxflags -DHAVE_UNIX"
    LDFLAGS="$LDFLAGS $my_sidplay2_ldadd"

    AC_TRY_LINK(
        [#include <sidplay/sidplay2.h>],
        [sidplay2 *myEngine;],
        [my_sidplay2_works=yes],
        [my_sidplay2_works=no]
    )

    AC_DEFINE(HAVE_UNIX)
    
    MY_TRY_LINK_RESTORE
])

dnl -------------------------------------------------------------------------
dnl Find libsidplay2 builders (sidbuilders) dir.
dnl @BUILDERS_INCLUDES@
dnl @BUILDERS_LDFLAGS@
dnl -------------------------------------------------------------------------
AC_DEFUN([BUILDERS_FIND],
[
    AC_MSG_CHECKING([for SIDPLAY2 builders directory])
    AC_REQUIRE([MY_PATH_LIBSIDPLAY2])

    dnl Be pessimistic.
    builders_available=no

    dnl Sidbuilder headers are included with "builders" prefix.
    builders_includedir=$my_sidplay2_includes
    builders_libdir=$my_sidplay2_builders

    dnl If libsidplay2 is in standard library search path, we need
    dnl to get an argument whether /usr, /usr/local, etc. Else we
    dnl can only use ${libdir}/sidplay/builders, but then are
    dnl unable to check whether files exist as long as ${exec_prefix}
    dnl is not defined in the configure script. So, this is a bit
    dnl ugly, but a satisfactory fallback default for those who
    dnl define ${prefix} and ${exec_prefix}.
    if test -z $builders_libdir; then
        eval "builders_libdir=$libdir/sidplay/builders"
    fi

    AC_ARG_WITH(sidbuilders,
        [  --with-sidbuilders=DIR  what the SIDPLAY2 builders install PREFIX is],
        [builders_includedir="$withval/include"
         builders_libdir="$withval/lib/sidplay/builders"]
    )
    AC_ARG_WITH(builders-inc,
        [  --with-builders-inc=DIR where the SIDPLAY2 builders headers are located],
        [builders_includedir="$withval"]
    )
    AC_ARG_WITH(builders-lib,
        [  --with-builders-lib=DIR where the SIDPLAY2 builders libraries are installed],
        [builders_libdir="$withval"]
    )
    
    if test -n "$builders_includedir"; then
        BUILDERS_INCLUDES="-I$builders_includedir"
    fi
    if test -n "$builders_libdir"; then
        BUILDERS_LDFLAGS="-L$builders_libdir"
    fi
    if test -d $builders_libdir; then
        my_have_sidbuilders_dir=yes
        AC_MSG_RESULT([$builders_libdir])
    else
        my_have_sidbuilders_dir=no
        AC_MSG_RESULT([$my_have_sidbuilders_dir])
        AC_MSG_ERROR([$builders_libdir not found!
Check --help on how to specify SIDPLAY2 and/or builders library and
header path, or set --exec-prefix to the same prefix as your installation
of libsidplay2.
        ])
    fi
    AC_SUBST(BUILDERS_INCLUDES)
    AC_SUBST(BUILDERS_LDFLAGS)
])

dnl -------------------------------------------------------------------------
dnl Test for working reSID builder.
dnl sets $(RESID_LDADD), substitutes @RESID_LDADD@
dnl -------------------------------------------------------------------------
AC_DEFUN([BUILDERS_FIND_RESID],
[
    AC_MSG_CHECKING([for reSID builder module])
    MY_TRY_LINK_SAVE
    
    CXX="${SHELL-/bin/sh} ${srcdir}/libtool --mode=link $CXX"
    CXXFLAGS="$CXXFLAGS $SIDPLAY_INCLUDES $BUILDERS_INCLUDES"
    LDFLAGS="$LDFLAGS $SIDPLAY_LDADD $BUILDERS_LDFLAGS"
    LIBS="$LIBS -lresid-builder"

    AC_TRY_LINK(
        [#include <sidplay/builders/resid.h>],
        [ReSIDBuilder *sid;],
        [builders_work=yes],
        [builders_work=no]
    )
    MY_TRY_LINK_RESTORE

    if test "$builders_work" = yes; then
        builders_available=yes
        AC_DEFINE(XSID_HAVE_RESID_BUILDER)
        RESID_LDADD="-lresid-builder"
    fi
    AC_MSG_RESULT($builders_work)
    AC_SUBST(RESID_LDADD)
])

dnl -------------------------------------------------------------------------
dnl Test for working HardSID builder.
dnl sets $(HARDSID_LDADD), substitutes @HARDSID_LDADD@
dnl -------------------------------------------------------------------------
AC_DEFUN([BUILDERS_FIND_HARDSID],
[
    AC_MSG_CHECKING([for HardSID builder module])
    MY_TRY_LINK_SAVE

    CXX="${SHELL-/bin/sh} ${srcdir}/libtool $CXX"
    CXXFLAGS="$CXXFLAGS $BUILDERS_INCLUDES"
    LDFLAGS="$LDFLAGS $BUILDERS_LDFLAGS"
    LIBS="$LIBS -lhardsid-builder"

    AC_TRY_LINK(
        [#include <sidplay/builders/hardsid.h>],
        [HardSID *sid;],
        [builders_work=yes],
        [builders_work=no]
    )
    MY_TRY_LINK_RESTORE

    if test "$builders_work" = yes; then
        builders_available=yes
        AC_DEFINE(XSID_HAVE_HARDSID_BUILDER)
        HARDSID_LDADD="-lhardsid-builder"
    fi
    AC_MSG_RESULT($builders_work)
    AC_SUBST(HARDSID_LDADD)
])

dnl -------------------------------------------------------------------------
dnl Try to find the X includes and libraries.
dnl @X_LDFLAGS@ will be substituted with -L$x_libraries
dnl @X_INCLUDES@ will be substituted with -I$x_includes
dnl Rest see AC_PATH_XTRA.
dnl -------------------------------------------------------------------------

AC_DEFUN([MY_PATH_X],
[
AC_REQUIRE([AC_PATH_XTRA])

if test -z "$x_includes" || test "x$x_includes" = xNONE; then
  X_INCLUDES=""
else
  X_INCLUDES="-I$x_includes"
fi

if test -z "$x_libraries" || test "$x_libraries" = xNONE; then
  X_LDFLAGS=""
else
  X_LDFLAGS="-L$x_libraries"
fi

AC_SUBST(X_INCLUDES)
AC_SUBST(X_LDFLAGS)

dnl These are now duplicates. Take them out. 
X_CFLAGS=""
X_LIBS=""
AC_SUBST(X_CFLAGS)
AC_SUBST(X_LIBS)
])

dnl ------------------------------------------------------------------------
dnl MY_PATH_QT, uses MY_PATH_QT
dnl Try to find the Qt headers and libraries.
dnl $(QT_LDFLAGS) will be -Lqtliblocation (if needed)
dnl and $(QT_INCLUDES) will be -Iqthdrlocation (if needed)
dnl ------------------------------------------------------------------------

AC_DEFUN([MY_FIND_QT],
[
#try to guess qt locations
if test "$my_qt_includes" = NO || test "$my_qt_libraries" = NO || test "$my_qt_binaries" = NO ; then

  qt_incdirs="$my_qt_includes /usr/lib/qt/include /usr/local/qt/include /opt/qt /usr/include/qt /usr/include/qt3 /usr/include /usr/X11R6/include/X11/qt $x_includes $QTINC"
  dnl If $QTDIR is set, move it to front.
  test -n "$QTDIR" && qt_incdirs="$QTDIR/include $QTDIR $qt_incdirs"
  dnl If dir is given as arg, move it to front.
  if test ! "$my_qt_includes" = "NO"; then
    qt_incdirs="$my_qt_includes $qt_incdirs"
  fi

  qt_libdirs="$my_qt_libraries /usr/lib/qt/lib /usr/local/qt/lib /opt/qt /usr/lib/qt /usr/lib $x_libraries $QTLIB"
  dnl If $QTDIR is set, move it to front.
  test -n "$QTDIR" && qt_libdirs="$QTDIR/lib $QTDIR $qt_libdirs"
  dnl If dir is given as arg, move it to front.
  if test ! "$my_qt_libraries" = "NO"; then
     qt_libdirs="$my_qt_libraries $qt_libdirs"
  fi

  qt_bindirs="$my_qt_libraries /usr/lib/qt/bin /usr/local/qt/bin /opt/qt/bin /usr/bin /usr/local/bin"
  dnl If $QTDIR is set, move it to front.
  test -n "$QTDIR" && qt_bindirs="$QTDIR/bin $QTDIR $qt_bindirs"
  dnl If dir is given as arg, move it to front.
  if test ! "$my_qt_binaries" = "NO"; then
     qt_bindirs="$my_qt_binaries $qt_bindirs"
  fi

else  dnl All given as argument(s).

  qt_incdirs="$my_qt_includes"
  qt_libdirs="$my_qt_libraries"
  qt_bindirs="$my_qt_binaries"

fi

dnl Locate some key files.
MY_FIND_FILE(qapplication.h, $qt_incdirs, qt_incdir)
my_qt_includes=$qt_incdir
MY_FIND_FILE(libqt-mt.so libqt-mt.so.3 libqt-mt.a libqt-mt.sl, $qt_libdirs, qt_libdir)
my_qt_libraries=$qt_libdir
MY_FIND_FILE(moc, $qt_bindirs, qt_bindir)
my_qt_binaries=$qt_bindir

if test "$my_qt_includes" = NO || test "$my_qt_libraries" = NO || test "$my_qt_binaries" = NO ; then
  dnl Create some nice error message about what is missing.
  my_cv_have_qt="have_qt=no"
  my_qt_notfound="("
  if test "$my_qt_includes" = NO; then
    my_qt_notfound="$my_qt_notfound headers"
  fi
  if test "$my_qt_libraries" = NO; then
    my_qt_notfound="$my_qt_notfound library"
  fi
  if test "$my_qt_binaries" = NO; then
    my_qt_notfound="$my_qt_notfound binaries"
  fi
  my_qt_notfound="$my_qt_notfound )"

  AC_MSG_ERROR([Qt $my_qt_notfound not found!]);
else
  my_cv_have_qt="have_qt=yes"
fi
])


AC_DEFUN([MY_PATH_QT],
[
AC_REQUIRE([AC_PATH_XTRA])
AC_MSG_CHECKING([for multi-threaded Qt])

my_qt_includes=NO
my_qt_libraries=NO
my_qt_binaries=NO
qt_includes=""
qt_libraries=""
qt_binaries=""

AC_ARG_WITH(qt-dir,
    [  --with-qt-dir           where the Qt root dir is ],
    [  my_qt_includes="$withval"/include
       my_qt_libraries="$withval"/lib
       my_qt_binaries="$withval"/bin
    ])

AC_ARG_WITH(qt-includes,
    [  --with-qt-includes      where the Qt includes are],
    [  my_qt_includes="$withval"
    ])
    
AC_ARG_WITH(qt-libraries,
    [  --with-qt-libraries     where the Qt libraries are],
    [  my_qt_libraries="$withval"
    ])

AC_ARG_WITH(qt-binaries,
    [  --with-qt-binaries      where the Qt binaries are],
    [  my_qt_binaries="$withval"
    ])

AC_CACHE_VAL(my_cv_have_qt,[MY_FIND_QT])
eval "$my_cv_have_qt"

if test "$have_qt" != yes; then
  AC_MSG_RESULT([$have_qt])
else
  my_cv_have_qt="have_qt=yes \
    my_qt_includes=$my_qt_includes \
    my_qt_libraries=$my_qt_libraries \
    my_qt_binaries=$my_qt_binaries"
  AC_MSG_RESULT([libraries $my_qt_libraries, headers $my_qt_includes, binaries $my_qt_binaries])
  
  qt_includes=$my_qt_includes
  qt_libraries=$my_qt_libraries
  qt_binaries=$my_qt_binaries
fi

if test "$qt_includes" = "$x_includes" || test -z "$qt_includes"; then
  QT_INCLUDES=""
else
  QT_INCLUDES="-I$qt_includes"
fi

if test "$qt_libraries" = "$x_libraries" || test -z "$qt_libraries"; then
  QT_LDFLAGS=""
else
  QT_LDFLAGS="-L$qt_libraries"
fi

MOC="$qt_binaries/moc"

AC_SUBST(QT_INCLUDES)
AC_SUBST(QT_LDFLAGS)
AC_SUBST(MOC)
])

dnl --- Testing for Qt >= 3.0 ---

AC_DEFUN([MY_TEST_QT_VERSION],
[
    AC_MSG_CHECKING([for Qt version 3.x])
    MY_TRY_LINK_SAVE
    
    CXX="${SHELL-/bin/sh} ${srcdir}/libtool --mode=link $CXX"
    CXXFLAGS="$CXXFLAGS $QT_INCLUDES"
    LDFLAGS="$LDFLAGS $QT_LDFLAGS"
    LIBS="$LIBS -lqt-mt"

    AC_TRY_LINK(
        [#include <qglobal.h>],
        [#if QT_VERSION < 0x030005
    #if QT_VERSION < 300
        #error Qt >= 3.0 required!
    #endif
#endif
        ],
        [my_good_qt=yes],
        [my_good_qt=no]
    )
    MY_TRY_LINK_RESTORE

    AC_MSG_RESULT($my_good_qt)
    if test "$my_good_qt" = no; then
        AC_MSG_ERROR([Qt 3.0 or higher is required!])
    fi
])
