/*
 *  XSMC-CALC: Smith Chart Calculator program for X
 * 
 *
 *      by Lapo Pieri (IK5NAX)  2000-2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Send bugs reports, comments, critique, etc, to ik5nax@amsat.org
 */

#include <stdio.h>
#include <math.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include <X11/Xlib.h>
#include <X11/cursorfont.h>
#include <X11/keysym.h>
#include "smc.h"

extern Display       *display;
extern GC            gc;
extern Window        window;
extern XEvent        event;
extern Pixmap        schart;
extern XFontStruct   *fontdialogname;

extern unsigned long numcolors, colorBLACK, colorWHITE, colorBG,
  colorZ, colorY, colorRHO, colorQ, colorSI, colorDW;
extern unsigned int wdim, scdim;
extern SMCDATA smcdata;


void dialogwin(char *head, char *menu, char *choice, char *b) {
  int i, needupdate=1;
  char c[3];
  const int DWLEN=15;

  XSetFont(display, gc, fontdialogname->fid);
  XSetForeground(display, gc, colorBLACK);
  XDrawString(display, schart, gc, 0.04*wdim+scdim+3, 
	      0.05*wdim+scdim-1+fontdialogname->ascent+fontdialogname->descent,
	      head, strlen(head));
  if(strlen(menu)!=0) { 
    XDrawString(display, schart, gc, 0.04*wdim+scdim+3, 
		0.05*wdim+scdim-1+0.3*(0.98*wdim-scdim-1)
		+fontdialogname->ascent+fontdialogname->descent,
		menu, strlen(menu));
    XCopyArea(display,schart, window, gc, 0, 0, 
	      wdim, wdim, 0, 0);
    XFlush(display); 
    
    
    do { XNextEvent(display, &event); } while
      (event.type==NoExpose || event.type==KeyRelease);
    if(event.type!=KeyPress) { b[0]='\0'; *choice='\0'; return; }
    i=XKeycodeToKeysym(display, event.xkey.keycode,event.xkey.state);      
    *choice=(char)(i&0x00ff);
    XSetForeground(display, gc, colorWHITE);
    XFillRectangle(display, schart, gc, 0.04*wdim+scdim+1, 
		   0.05*wdim+scdim+1+0.3*(0.98*wdim-scdim-1),
		   0.8*(0.98*wdim-scdim-1), 0.2*(0.98*wdim-scdim-1));
    sprintf(c, "%c", *choice);
    XSetForeground(display, gc, colorBLACK);
    XDrawString(display, schart, gc, 0.04*wdim+scdim+3, 
		0.05*wdim+scdim-1+0.3*(0.98*wdim-scdim-1)
		+fontdialogname->ascent+fontdialogname->descent,
		c, strlen(c));
  }
  else
    choice[0]='\0';

  b[0]='\0';
  while(1) {
    if(needupdate){
      XCopyArea(display,schart, window, gc, 0, 0, 
		wdim, wdim, 0, 0);
      XFlush(display); 
      needupdate=0;
    }
    
    XNextEvent(display, &event);

    switch(event.type){
    case KeyPress:
      i=XKeycodeToKeysym(display, event.xkey.keycode,event.xkey.state);      
      if(i==XK_Return) { 
	/* Repaint the dialog window */
	XSetForeground(display, gc, colorDW);
	XFillRectangle(display, schart, gc, 
		       0.02*wdim+scdim+1, 0.02*wdim+scdim+1, 
		       0.98*wdim-scdim-1, 0.98*wdim-scdim-1);
	XSetForeground(display, gc, colorWHITE);
	XFillRectangle(display, schart, gc, 
		       0.04*wdim+scdim+1, 0.05*wdim+scdim+1,
		       0.8*(0.98*wdim-scdim-1), 0.2*(0.98*wdim-scdim-1));
	XFillRectangle(display, schart, gc, 0.04*wdim+scdim+1, 
		       0.05*wdim+scdim+1+0.3*(0.98*wdim-scdim-1),
		       0.8*(0.98*wdim-scdim-1), 0.2*(0.98*wdim-scdim-1));
	XFillRectangle(display, schart, gc, 0.04*wdim+scdim+1, 
		       0.05*wdim+scdim+1+0.6*(0.98*wdim-scdim-1),
		       0.8*(0.98*wdim-scdim-1), 0.2*(0.98*wdim-scdim-1));
	XCopyArea(display,schart, window, gc, 0, 0, 
		  wdim, wdim, 0, 0);
	XFlush(display); 
	return;
      }
      if(i==XK_BackSpace) { b[strlen(b)-1]='\0'; i=0; needupdate=1; }
      if(i>0xff) continue;
      if(strlen(b)<DWLEN) {
	sprintf(c, "%c", i); strcat(b, c); 
	XSetForeground(display, gc, colorWHITE);
	XFillRectangle(display, schart, gc, 0.04*wdim+scdim+1, 
		       0.05*wdim+scdim+1+0.3*(0.98*wdim-scdim-1),
		       0.8*(0.98*wdim-scdim-1), 0.2*(0.98*wdim-scdim-1));
	XFillRectangle(display, schart, gc, 0.04*wdim+scdim+1, 
		       0.05*wdim+scdim+1+0.6*(0.98*wdim-scdim-1),
		       0.8*(0.98*wdim-scdim-1), 0.2*(0.98*wdim-scdim-1));
       	sprintf(c, "%c", *choice);
	XSetForeground(display, gc, colorBLACK);
	XDrawString(display, schart, gc, 0.04*wdim+scdim+3, 
		    0.05*wdim+scdim-1+0.3*(0.98*wdim-scdim-1)
		    +fontdialogname->ascent+fontdialogname->descent,
		    c, strlen(c));	
	XSetForeground(display, gc, colorBLACK);
	XDrawString(display, schart, gc, 0.04*wdim+scdim+3, 
		    0.05*wdim+scdim-1+0.6*(0.98*wdim-scdim-1)+
		    fontdialogname->ascent+fontdialogname->descent,
		    b, strlen(b));
	needupdate=1;
      }
    case NoExpose:
      break;
    case KeyRelease:
      break;
    default:
      b[0]='\0';	
      /* Repaint the dialog window */
      XSetForeground(display, gc, colorDW);
      XFillRectangle(display, schart, gc, 
		     0.02*wdim+scdim+1, 0.02*wdim+scdim+1, 
		     0.98*wdim-scdim-1, 0.98*wdim-scdim-1);
      XSetForeground(display, gc, colorWHITE);
      XFillRectangle(display, schart, gc, 
		     0.04*wdim+scdim+1, 0.05*wdim+scdim+1,
		     0.8*(0.98*wdim-scdim-1), 0.2*(0.98*wdim-scdim-1));
      XFillRectangle(display, schart, gc, 0.04*wdim+scdim+1, 
		     0.05*wdim+scdim+1+0.3*(0.98*wdim-scdim-1),
		     0.8*(0.98*wdim-scdim-1), 0.2*(0.98*wdim-scdim-1));
      XFillRectangle(display, schart, gc, 0.04*wdim+scdim+1, 
		     0.05*wdim+scdim+1+0.6*(0.98*wdim-scdim-1),
		     0.8*(0.98*wdim-scdim-1), 0.2*(0.98*wdim-scdim-1));
      XCopyArea(display,schart, window, gc, 0, 0, 
		wdim, wdim, 0, 0);
      XFlush(display); 
      return;
    }
  }
}




int entrystringdecode(char *is, float *re, float *im){
  int i, fn, err;
  char *b;

  /* Remove initial spaces, it will be usefull later */
  b=is; while(b[0]==' ' || b[0]=='\t') b++;
  
  err=0;
  for(i=0; i<strlen(b); i++) {
    /* If a 'j' is present than swap it with the sign and replace it
       with blank, e.g.: "12+j56" --> "12 +56" */ 
    if(b[i]=='j') {
      /* Except if 'j' is the first character as in "j78.34" */
      if(i!=0) {
	b[i]=b[i-1]; b[i-1]=' '; }
      else
	b[0]=' ';
      /* The string is ready to be read by a scanf, but if only one field
	 is found this mean that it's a pure immaginary number */
      if(sscanf(b, "%f %f", re, im)<2) { *im=*re; *re=0; }
      break;
    }
  }
  /* If no 'j' are found there may be one or more field separated by
     space or tab*/
  if(i==strlen(b)) {
    if(strlen(b)==0) 
      err=1;
    else 
      fn=1;
    
    /* Search for field delimiter */
    for(i=0; i<strlen(b); i++) {
      /* To do better: to detect multiple spaces or tab or trailing ones */
      if(b[i]==' ') fn++;
    }
    
    switch(fn) {
    case 1:                                 /* Single field, a real number */
      if(sscanf(b, "%f", re)==0)
	err=1;
      *im=0; break;
      
    case 2:                             /* Complex number in polar format */ 
      if(sscanf(b, "%f %f", re, im)==0)
	err=1;
      polar2rect(re, im); break;
      
    case 3:                         /* In futuro per le linee (Z0, E, Att) */
      break;
      
    default:
      err=1;
    }    
  }
  
  return err;
}


/* Decode values of component from string received by dialogwin() */
int componentvaluestringdecode(char *is, float *val0, float *val1,
			       float *val2, char *place) {
  int ni;
  char f0[10], f1[10], f2[10], f3[10];

  ni=sscanf(is, "%s %s %s %s", f0, f1, f2, f3);
  switch(ni) {
  case 0:
  case 1:
    fprintf(stderr, "Invalid component value\n"); return 1;

  case 2: *place=f1[0]; *val0=psdec(f0); *val1=0.; *val2=0.; break;

  case 3: *place=f2[0]; *val0=psdec(f0); *val1=psdec(f1); *val2=0; break;

  default: fprintf(stderr, "Invalid component value\n"); return 1;
  }

  return 0;
}

/* Decode float value with unit of measure prefix (but not unit of measure
   symbol) */
float psdec(char *b) {
  int i;
  float pf=1., v;
  char b2[40];

  for(i=0; i<strlen(b); i++)
    if((b[i]>'9' || b[i]<'0') && b[i]!='.' && b[i]!='-' && b[i]!='+') break;
  
  if(i!=strlen(b))
    switch(b[i]) {
    case 'f': pf=1.e-15; break;
    case 'p': pf=1.e-12; break;
    case 'n': pf=1.e-9; break;
    case 'u': pf=1.e-6; break;
    case 'm': pf=1.e-3; break;
    case 'k': pf=1.e+3; break;
    case 'M': pf=1.e+6; break;
    case 'G': pf=1.e+9; break;
    case 'T': pf=1.e+12; break;
    case ' ': pf=1.; break;
    default: fprintf(stderr, "Invalid prefix (%c)\n", b[i]); return(0.);
    }

  strncpy(b2, b, i+2);
  sscanf(b2, "%f", &v);

  return (v*pf);
}
