#!/bin/sh -
PATH=/bin:/usr/bin; export PATH

# xtitle - set window title and icon name for an X11 terminal window
# Steve Kinzler, kinzler@cs.indiana.edu, Nov 93/Nov 98/Mar 00/Dec 09
# see website http://www.cs.indiana.edu/~kinzler/xtitle/
# http://www.cs.indiana.edu/~kinzler/home.html#x11

# An older version of this script (not recommended for use in dtterm's)
# is packaged for Solaris and available at
#	http://metalab.unc.edu/pub/solaris/sparc/

#   Copyright
#
#	Copyright (C) 1993 Stephen B Kinzler <kinzler@cs.indiana.edu>
#
#   License
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program. If not, see <http://www.gnu.org/licenses/>.

#version=1.0.0
version=1.0.1	# 2009-12-10: add copyright/GPL notice for debian pkg
version=1.0.2	# 2009-12-18: add -V option, long options

dflttarg=ti
target=; bad=

while :
do
	case $# in
	0)	break;;
	*)	case "$1" in
		-[tiqV]*)	target="${target}$1";;
		--title)	target="${target}-t";;
		--icon)		target="${target}-i";;
		--quiet)	target="${target}-q";;
		--version)	target="${target}-V";;

		--)		shift; break;;
		-h|--help)	bad=t; break;;
		-*)		bad=t; echo "$0: unknown option ($1)" 1>&2;;
		*)		break;;
		esac
		shift;;
	esac
done

case "$target" in
*V*)	echo "$version"; exit 0;;
esac

case "$#,$bad" in
0,*|*,?*)	cat << EOF 1>&2
usage: $0 [ -tiq ] string ... | -V
	-t, --title	set window title
	-i, --icon	set icon name
	-q, --quiet	quiet mode, don't report settings
	-V, --version	only output program version
Without -t or -i options, both the window title and icon name are set.
Version $version
EOF
		exit 1;;
esac

case "$target" in
''|-q)	target="$target$dflttarg";;
esac

case "$target" in
*t*)	case "$target" in
	*q*)	echo "]2;$*" | tr -d '\012';;
	*)	echo "]2;$*title = $*";;
	esac;;
esac
case "$target" in
*i*)	case "$target" in
	*q*)	echo "]1;$*" | tr -d '\012';;
	*)	echo "]1;$*icon  = $*";;
	esac;;
esac
